<?php

if (!function_exists('dd')) {
    function dd($data) {
        echo '<pre>';
        print_r($data);
        echo '</pre>';
        exit;
    }
}

function get_env($key, $default = null) {
    return isset($_ENV[$key]) ? $_ENV[$key] : $default;
}

/**
 * Simple function to sanitize output (XSS protection)
 */
function e($string) {
    return htmlspecialchars($string, ENT_QUOTES, 'UTF-8');
}

/**
 * Basic HTTP GET using cURL
 */
function http_get($url, $headers = []) {
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_TIMEOUT => 20,
        CURLOPT_HTTPHEADER => $headers,
        CURLOPT_USERAGENT => 'Mozilla/5.0 (OneFootball Scraper Bot)',
    ]);
    $response = curl_exec($ch);
    if (curl_errno($ch)) {
        $error = curl_error($ch);
        curl_close($ch);
        throw new Exception('HTTP GET error: ' . $error);
    }
    $statusCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    if ($statusCode >= 400) {
        throw new Exception('HTTP GET status code: ' . $statusCode);
    }
    return $response;
}

/**
 * Basic HTTP POST using cURL
 */
function http_post($url, $body, $headers = [], $isJson = true) {
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => $body,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_HTTPHEADER => $headers,
    ]);
    $response = curl_exec($ch);
    if (curl_errno($ch)) {
        $error = curl_error($ch);
        curl_close($ch);
        throw new Exception('HTTP POST error: ' . $error);
    }
    $statusCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    if ($statusCode >= 400) {
        throw new Exception('HTTP POST status code: ' . $statusCode . ' Response: ' . $response);
    }
    return $response;
}
