CREATE TABLE IF NOT EXISTS templates (
  id INT AUTO_INCREMENT PRIMARY KEY,
  name VARCHAR(100),
  api_key TEXT,
  model VARCHAR(100),
  temperature FLOAT,
  max_tokens INT,
  top_p FLOAT,
  top_k INT,
  wp_domain VARCHAR(255),
  wp_user VARCHAR(100),
  wp_app_pass VARCHAR(255),
  wp_category INT,
  img_source VARCHAR(255) DEFAULT 'OneFootball',
  rewrite_prompt LONGTEXT NULL,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE IF NOT EXISTS articles (
  id INT AUTO_INCREMENT PRIMARY KEY,
  source_url TEXT,
  title TEXT,
  content LONGTEXT,
  img_url TEXT,
  published_at DATETIME,
  status ENUM('draft','processed','posted') DEFAULT 'draft',
  rewritten LONGTEXT
);
