<?php
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../core/helper.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['create'])) {
    $stmt = $pdo->prepare("INSERT INTO templates (name, api_key, model, temperature, max_tokens, top_p, top_k, wp_domain, wp_user, wp_app_pass, wp_category, img_source, rewrite_prompt) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->execute([
        $_POST['name'] ?? '',
        $_POST['api_key'] ?? '',
        $_POST['model'] ?? 'gemini-1.5-pro',
        $_POST['temperature'] ?? 0.6,
        $_POST['max_tokens'] ?? 3000,
        $_POST['top_p'] ?? 0.95,
        $_POST['top_k'] ?? 40,
        $_POST['wp_domain'] ?? '',
        $_POST['wp_user'] ?? '',
        $_POST['wp_app_pass'] ?? '',
        $_POST['wp_category'] ?? 0,
        $_POST['img_source'] ?? 'OneFootball',
        $_POST['rewrite_prompt'] ?? '',
    ]);
    header('Location: templates.php?success=1');
    exit;
}

$templates = $pdo->query("SELECT * FROM templates ORDER BY id DESC")->fetchAll();
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Kelola Template</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
</head>
<body class="bg-light">
<div class="container py-4">
    <h1 class="mb-4">Kelola Template</h1>
    <a href="index.php" class="btn btn-secondary mb-3">← Kembali ke Dashboard</a>

    <?php if (!empty($_GET['success'])): ?>
        <div class="alert alert-success">Template berhasil disimpan.</div>
    <?php endif; ?>

    <div class="row">
        <div class="col-md-6">
            <div class="card mb-4">
                <div class="card-header">Template Baru</div>
                <div class="card-body">
                    <form method="post">
                        <input type="hidden" name="create" value="1">
                        <div class="mb-3">
                            <label class="form-label">Nama Template</label>
                            <input type="text" name="name" class="form-control" required>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">API Key Google AI (Gemini)</label>
                            <input type="text" name="api_key" class="form-control" required>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Model Gemini</label>
                            <input type="text" name="model" class="form-control" value="gemini-1.5-pro">
                        </div>

                        <div class="row">
                            <div class="col-4 mb-3">
                                <label class="form-label">Temperature</label>
                                <input type="number" step="0.1" name="temperature" class="form-control" value="0.6">
                            </div>
                            <div class="col-4 mb-3">
                                <label class="form-label">Max Tokens</label>
                                <input type="number" name="max_tokens" class="form-control" value="3000">
                            </div>
                            <div class="col-4 mb-3">
                                <label class="form-label">Top P</label>
                                <input type="number" step="0.01" name="top_p" class="form-control" value="0.95">
                            </div>
                            <div class="col-4 mb-3">
                                <label class="form-label">Top K</label>
                                <input type="number" name="top_k" class="form-control" value="40">
                            </div>
                        </div>

                        <hr>

                        <div class="mb-3">
                            <label class="form-label">Domain WordPress</label>
                            <input type="text" name="wp_domain" class="form-control" placeholder="https://domainmu.com" required>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Username Admin WP</label>
                            <input type="text" name="wp_user" class="form-control" required>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Application Password WP</label>
                            <input type="text" name="wp_app_pass" class="form-control" required>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">ID Kategori WP</label>
                            <input type="number" name="wp_category" class="form-control" value="0">
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Sumber Gambar (untuk caption)</label>
                            <input type="text" name="img_source" class="form-control" value="OneFootball">
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Rewrite Prompt</label>
                            <textarea name="rewrite_prompt" class="form-control" rows="10"></textarea>
                            <div class="form-text">Tempel prompt Bahasa Indonesia atau Inggris sesuai kebutuhan.</div>
                        </div>

                        <button class="btn btn-success" type="submit">Simpan Template</button>
                    </form>
                </div>
            </div>
        </div>

        <div class="col-md-6">
            <h2 class="h5">Daftar Template</h2>
            <table class="table table-striped table-bordered">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Nama</th>
                        <th>Domain</th>
                        <th>Model</th>
                        <th>Kategori</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                <?php foreach ($templates as $t): ?>
                    <tr>
                        <td><?= e($t['id']) ?></td>
                        <td><?= e($t['name']) ?></td>
                        <td><?= e($t['wp_domain']) ?></td>
                        <td><?= e($t['model']) ?></td>
                        <td><?= e($t['wp_category']) ?></td>
                        <td><a class="btn btn-sm btn-outline-primary" href="edit_template.php?id=<?= e($t['id']) ?>">Edit</a></td>
                    </tr>
                <?php endforeach; ?>
                <?php if (empty($templates)): ?>
                    <tr><td colspan="6" class="text-center">Belum ada template.</td></tr>
                <?php endif; ?>
                </tbody>
            </table>

            <p>Gunakan <strong>ID</strong> di tabel ini untuk parameter <code>template_id</code> pada URL cron.</p>
        </div>
    </div>
</div>
</body>
</html>
